jQuery(document).ready(function ($) {
    $('#scrada_test_connection').click(function (e) {
        e.preventDefault();
        var $btn = $(this);
        var $status = $('#scrada_connection_status');

        $btn.prop('disabled', true).text('Testing...');
        $status.text('').removeClass('dashicons dashicons-yes dashicons-no');

        // Grab values directly from inputs to test unsaved changes
        var apiKey = $('input[name="scrada_api_key"]').val();
        var apiSecret = $('input[name="scrada_api_secret"]').val();
        var companyId = $('input[name="scrada_company_id"]').val();
        var testMode = $('input[name="scrada_test_mode"]').is(':checked') ? 1 : 0;

        var nonce = scradaLiteAdminParams.nonce;

        $.post(ajaxurl, {
            action: 'scrada_verify_connection',
            nonce: nonce,
            api_key: apiKey,
            api_secret: apiSecret,
            company_id: companyId,
            test_mode: testMode
        }, function (response) {
            $btn.prop('disabled', false).text('Test Connection');
            if (response.success) {
                $status.text(' ' + response.data).css('color', 'green').addClass('dashicons dashicons-yes');
            } else {
                $status.text(' ' + response.data).css('color', 'red').addClass('dashicons dashicons-no');
            }
        });
    });
});
